--- BunkerSiloHUD.lua ---
---    by XPModder    ---
---     14.10.2020    ---

BunkerSiloHUD = {}

BunkerSiloHUD.metadata = {
    name = "Bunker Silo HUD",
    author = "XPModder",
    version = "3.1.0",
    created = "14.10.2020",
    updated = "03.12.2024",
    fsVersion = "25",
    info = "Adds a small HUD for Bunker Silos, so you don#t have to open F1 to see the current progress"
}



BunkerSiloHUD.path = tostring(g_currentModDirectory.."back.dds")

BunkerSiloHUD.posX = 0.88
BunkerSiloHUD.posY = 0.8
BunkerSiloHUD.size = 0.018
BunkerSiloHUD.sizeHeader = 0.020
BunkerSiloHUD.width = 0.12
BunkerSiloHUD.height = 0.14

BunkerSiloHUD.backgroundOL = g_currentModDirectory.."back.dds"

BunkerSiloHUD.drawOverlay = false

BunkerSiloHUD.line1 = ""
BunkerSiloHUD.line2 = ""
BunkerSiloHUD.line3 = ""


function BunkerSiloHUD.updateSilo(self, superFunc, dt)

    local returnValue = superFunc(self, dt)

    if self == nil then
        return
    end

    if self:getCanInteract(true) then
        if g_currentMission.hud.isVisible then
            if not g_gui:getIsGuiVisible() then

                self.currentFillLevel = math.ceil(self.fillLevel, 0)

                if self.state == BunkerSilo.STATE_FILL then
                    self.currentFermentingPercent = 0
                    self.currentCompactedPercent = self.compactedPercent
                else
                    self.currentFermentingPercent = math.ceil((self.fermentingPercent * 100), 0)
                    self.currentCompactedPercent = 100
                end

                local fillTypeIndex = self.inputFillType

                if self.state == BunkerSilo.STATE_CLOSED or self.state == BunkerSilo.STATE_FERMENTED or self.state == BunkerSilo.STATE_DRAIN then
                    fillTypeIndex = self.outputFillType
                end

                local fillType = g_fillTypeManager:getFillTypeByIndex(fillTypeIndex)
                if fillType ~= nil then
                    fillTypeName = fillType.title
                end

                local fillTypeLabel = g_i18n:getText("hud_filltype").." "..tostring(fillTypeName)
                local fillLevelLabel = g_i18n:getText("hud_filllevel").." "..tostring(math.ceil(self.fillLevel)).." L"
                local compacted = g_i18n:getText("hud_compacted").." "..tostring(self.compactedPercent).."%"
                local fermented = g_i18n:getText("hud_fermenting").." "..tostring(self.currentFermentingPercent).."%"
                
                BunkerSiloHUD.line1 = tostring(fillTypeLabel)
                BunkerSiloHUD.line2 = tostring(fillLevelLabel)
                BunkerSiloHUD.line3 = ""

                if self.state == BunkerSilo.STATE_CLOSED or self.state == BunkerSilo.STATE_FERMENTED then
                    BunkerSiloHUD.line3 = tostring(fermented)
                elseif self.state == BunkerSilo.STATE_FILL then
                    BunkerSiloHUD.line3 = tostring(compacted)
                end

                BunkerSiloHUD.drawOverlay = true

            end
        end
    end

    return returnValue

end


function BunkerSiloHUD:loadMap(filename)
    print("--- Mod: "..BunkerSiloHUD.metadata.name..", Version "..BunkerSiloHUD.metadata.version.." for Farming Simulator "..BunkerSiloHUD.metadata.fsVersion.." loaded! ---")
end


function BunkerSiloHUD.createImageOverlay(texturePath)

    return Overlay.new(texturePath, BunkerSiloHUD.posX - 0.008, BunkerSiloHUD.posY - 0.08, BunkerSiloHUD.width, BunkerSiloHUD.height)

end


function BunkerSiloHUD:draw()

    if BunkerSiloHUD.drawOverlay then
        if g_currentMission.hud.isVisible then
            
            local overlay = BunkerSiloHUD.createImageOverlay(BunkerSiloHUD.backgroundOL)

            overlay:setColor(1.0, 1.0, 1.0, 1.0)
            overlay:render()
            setTextColor(1,1,1,1)
            setTextAlignment(RenderText.ALIGN_LEFT)

            setTextBold(true)
            renderText(BunkerSiloHUD.posX, BunkerSiloHUD.posY + 0.03, BunkerSiloHUD.sizeHeader, g_i18n:getText("hud_bunkersilo"))
            setTextBold(false)

            renderText(BunkerSiloHUD.posX, BunkerSiloHUD.posY, BunkerSiloHUD.size, tostring(BunkerSiloHUD.line1))
            renderText(BunkerSiloHUD.posX, BunkerSiloHUD.posY - 0.03, BunkerSiloHUD.size, tostring(BunkerSiloHUD.line2))

            renderText(BunkerSiloHUD.posX, BunkerSiloHUD.posY - 0.06, BunkerSiloHUD.size, tostring(BunkerSiloHUD.line3))

            BunkerSiloHUD.drawOverlay = false

        end
    end

end



addModEventListener(BunkerSiloHUD)

BunkerSilo.update = Utils.overwrittenFunction(BunkerSilo.update, BunkerSiloHUD.updateSilo)
