AutomaticWateringSystem = {}

source(g_currentModDirectory.."WateringStateEvent.lua");

function AutomaticWateringSystem:loadMap(name)
	if g_currentMission:getIsServer() or g_currentMission.isMasterUser then
		g_messageCenter:subscribe(MessageType.HOUR_CHANGED, self.HourChanged, self)
    end;
end

function AutomaticWateringSystem:HourChanged()
	for i=#g_currentMission.placeableSystem.placeables, 1, -1 do
        local Iplaceable = g_currentMission.placeableSystem.placeables[i];
        if Iplaceable ~= nil and Iplaceable.AutoWatering and Iplaceable.spec_productionPoint ~= nil and Iplaceable.spec_productionPoint.productionPoint ~= nil then
			local IproductionPoint = Iplaceable.spec_productionPoint.productionPoint;

			local Amount = IproductionPoint.storage:getFreeCapacity(FillType.WATER, true)/12;
			local Price = g_fillTypeManager:getFillTypeByIndex(FillType.WATER).pricePerLiter * Amount;

			g_currentMission:addMoney(-Price, IproductionPoint:getOwnerFarmId(), MoneyType.PRODUCTION_COSTS, false);
			IproductionPoint.storage:setFillLevel(IproductionPoint.storage:getFillLevel(FillType.WATER) + Amount, FillType.WATER)

			--print("Amount"); print(Amount); print("Price"); print(Price);
        end;
    end
end

function AutomaticWateringSystem:InsertSpecialization()
    if g_placeableSpecializationManager:getSpecializationByName("AutomaticWateringSpecialization") == nil then
        g_placeableSpecializationManager:addSpecialization("AutomaticWateringSpecialization", "AutomaticWateringSpecialization", Utils.getFilename("AutomaticWateringSpecialization.lua", g_currentModDirectory), nil)
    end

    TypeManager.validateTypes = Utils.appendedFunction(TypeManager.validateTypes, function(self)
        if self.typeName == "placeable" then
            for placeableType, placeable in pairs(g_placeableTypeManager:getTypes()) do
                if SpecializationUtil.hasSpecialization(PlaceableProductionPoint, placeable.specializations) then
					g_placeableTypeManager:addSpecialization(placeableType, "AutomaticWateringSpecialization")
                end
            end
        end
    end)
end

function AutomaticWateringSystem:UpdateMenuButtons()
	if self.selectedProductionPoint == nil then return end
	if self.selectedProductionPoint.owningPlaceable == nil then return end
	if self.selectedProductionPoint.owningPlaceable:getOwnerFarmId() == nil then return end

	if g_currentMission:getFarmId() ~= self.selectedProductionPoint.owningPlaceable:getOwnerFarmId() then return end
	if not self.selectedProductionPoint.storage:getIsFillTypeSupported(FillType.WATER) then return end;

	if self.AutoWateringButton == nil then
		self.AutoWateringButton = {
			profile = "buttonOk",
			inputAction = InputAction.MENU_EXTRA_2,
			text = ButtonText,
			callback = function()
				self.selectedProductionPoint.owningPlaceable.AutoWatering = not self.selectedProductionPoint.owningPlaceable.AutoWatering
				self.AutoWateringButton.text = g_i18n:getText(self.selectedProductionPoint.owningPlaceable.AutoWatering and "text_DisableWatering" or "text_EnableWatering")
				self.pointsList:reloadData()

				WateringStateEvent:sendEvent(self.selectedProductionPoint.owningPlaceable, self.selectedProductionPoint.owningPlaceable.AutoWatering);
			end
		}
	end

    self.AutoWateringButton.text = g_i18n:getText(self.selectedProductionPoint.owningPlaceable.AutoWatering and "text_DisableWatering" or "text_EnableWatering")
	table.insert(self.menuButtonInfo, self.AutoWateringButton)

	self:setMenuButtonInfoDirty()
end

InGameMenuProductionFrame.updateMenuButtons = Utils.appendedFunction(InGameMenuProductionFrame.updateMenuButtons, AutomaticWateringSystem.UpdateMenuButtons)
AutomaticWateringSystem:InsertSpecialization();
addModEventListener(AutomaticWateringSystem)

